use sysinfo::{System, SystemExt, CpuExt};
use std::{thread, time};
use std::io::{self, Write};

fn main() {
    let mut sys = System::new_all();

    println!("=== Wouam SysMonitor v1.1 ===");
    println!("Système : {} {}", sys.name().unwrap_or("?".to_string()), sys.os_version().unwrap_or("?".to_string()));
    println!("Hôte    : {}", sys.host_name().unwrap_or("?".to_string()));
    println!("-----------------------------");

    loop {
        sys.refresh_all();

        // Affichage CPU
        print!("\rCPU: {:.2}%  ", sys.global_cpu_info().cpu_usage());

        // Affichage RAM (CORRECTION ICI : On divise 3 fois par 1024 pour passer des Octets aux Go)
        // Octets -> Ko -> Mo -> Go
        let used_mem = sys.used_memory() as f64 / 1024.0 / 1024.0 / 1024.0;
        let total_mem = sys.total_memory() as f64 / 1024.0 / 1024.0 / 1024.0;
        
        print!("| RAM: {:.2} GB / {:.2} GB    ", used_mem, total_mem);

        // Rafraîchissement console
        io::stdout().flush().unwrap();
        thread::sleep(time::Duration::from_secs(2));
    }
}