use sha2::{Sha256, Digest};
use std::env;
use std::fs::File;
use std::io::{self, Read};

fn main() -> io::Result<()> {
    let args: Vec<String> = env::args().collect();
    if args.len() < 2 {
        println!("Usage: cargo run <chemin_du_fichier>");
        return Ok(());
    }

    let path = &args[1];
    println!("Calcul du hash SHA-256 pour : {}", path);

    let mut file = File::open(path)?;
    let mut hasher = Sha256::new();
    let mut buffer = [0; 1024];

    loop {
        let count = file.read(&mut buffer)?;
        if count == 0 {
            break;
        }
        hasher.update(&buffer[..count]);
    }

    let result = hasher.finalize();
    println!("----------------------------------------------------------------");
    println!("HASH: {}", hex::encode(result));
    println!("----------------------------------------------------------------");

    Ok(())
}